 ; Ŀ
 ;   Black - colour everything white (so it will print black.)             
 ;   Copyright 1998, 2008 by Rocket Software Ltd.                          
 ;                                                                         
 ;   Caution: explodes dimensions, may crash drawings, doesn't like        
 ;   the blocks Gasket1 and Gasket2.                                       
 ; 

 ; Ŀ
 ;   Subroutine Ezo2 - whitewash all block and dimension subentities.      
 ; 
 (DEFUN EZO2 (/ ss enam typ entt blnam blist)
  (setq ss (ssget "X" (list (cons 0 "insert,dimension"))))
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq entt (entget enam))
         (setq num (1+ num))
         (setq blnam (cdr (assoc 2 entt)))
         (if (not (member blnam blist))
             (progn
                  (setq blist (append blist (list blnam)))
                  (taze blnam))))
 (princ))
 ; Ŀ
 ;   Subroutine Ezo2 end.                                                  
 ; 

 ; Ŀ
 ;   Sirv: explicitly colour and linetype entities if they have no colour  
 ;   or linetype and the layer they occupy has.                            
 ; 
 (DEFUN SIRV (laya ss / num enam entt pa elay asoc8 ecol asoc62 eltyp asoc6
                                                                      ladat)
  (setq num 0)
 ; Ŀ
 ;   For each entity in the selection set:                                 
 ; 
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (setq entt (entget enam))
         (setq pa (cdr (assoc 10 entt)))                  ; entity insertion
         (setq elay (cdr (setq asoc8 (assoc 8 entt))))    ; entity layer
         (setq ecol (cdr (setq asoc62 (assoc 62 entt))))  ; entity colour
         (setq eltyp (cdr (setq asoc6 (assoc 6 entt))))   ; entity linetype
 ; Ŀ
 ;   Get the data for the layer occupied by the entity.                    
 ; 
         (setq ladat (tblsearch "layer" elay))
 ; Ŀ
 ;   If the entity is coloured bylayer, explicitly colour it.              
 ; 
         (cond ((null ecol)
                (entmod (setq entt (append entt (list (assoc 62 ladat))))))
               ((= ecol 256)
                (entmod (setq entt (subst (assoc 62 ladat) asoc62 entt)))))
 ; Ŀ
 ;   If the entity was linetyped bylayer, explicitly linetype it.          
 ; 
         (cond ((null eltyp)
                (entmod (setq entt (append entt (list (assoc 6 ladat))))))
               ((= (strcase eltyp t) "byblock")
                (entmod (setq entt (subst (assoc 6 ladat) asoc6 entt)))))
 ; Ŀ
 ;   Move the entity to the destination layer.                             
 ; 
         (entmod (subst (cons 8 laya) asoc8 entt)))
 (princ))
 ; Ŀ
 ;   Sirv end.                                                             
 ; 

 ; Ŀ
 ;   Taze - the mechanical part - written as a subroutine for ease of      
 ;   recursion.                                                            
 ; 
 (DEFUN TAZE (blnam / blok namm entt num gnu nxt hi ss enam)
  (setq blok (tblsearch "block" blnam))               ; head entity from table
  (grtext -2 blnam)
  (setq namm (cdr (assoc -2 blok)))                   ; first ename after head
  (while namm
        (setq entt (entget namm))                     ; the whole thing
        (if (or (= (cdr (assoc 0 entt)) "INSERT")     ; if it's another block
                (= (cdr (assoc 0 entt)) "DIMENSION")) ; or a dimension
            (taze (cdr (assoc 2 entt))))              ; then recurse
        (setq num 0)
        (setq gnu ())
        (while (setq nxt (nth num entt))
               (setq num (1+ num))
               (cond ((= (car nxt) 8)
                      (setq gnu (append gnu (list (cons 8 "0")))))
                     ((= (car nxt) 62)
                      (setq gnu (append gnu (list (cons 62 0)))))
                     (t  
                      (setq gnu (append gnu (list nxt))))))
        (if (null (assoc 62 gnu))
            (setq gnu (append gnu (list (cons 62 0)))))
        (entmod gnu)                         ; change subent in block tables
        (setq namm (entnext namm)))          ; next subentity ename
 ; Ŀ
 ;   Update the individual insertions.                                     
 ; 
  (if (= (substr blnam 1 1) "*")
      (setq blnam (strcat "`" blnam)))
  (setq ss (ssget "X" (list (cons 2 blnam))))
  (setq num 0)
  (while (and ss (setq esav (setq enam (ssname ss num))))
         (setq num (1+ num))
         (if (assoc 66 (entget enam))
             (progn
                  (while (/= (cdr (assoc 0 (setq entt (entget 
                                      (setq enam (entnext enam)))))) "SEQEND")
                         (setq entt (subst (cons 8 "0") (assoc 8 entt) entt))
                         (if (setq asoc62 (assoc 62 entt))
                             (setq entt (subst (cons 62 0) asoc62 entt))
                             (setq entt (append entt (list (cons 62 0)))))
                         (entmod entt))))
         (entupd esav))
 (princ))
 ; Ŀ
 ;   Taze end.                                                             
 ; 

 ; Ŀ
 ;   Black.                                                                
 ; 
 (DEFUN C:BLACK (/ ss enam)
  (setvar "cmdecho" 0)
  (setq ss (ssget "X" (list (cons 0 "dimension"))))
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (command "explode" enam)
         (setq num (1+ num)))
  (setq ss (ssget "X"))
  (sirv "0" ss)
  (command "change" ss "" "p" "layer" "0" "color" "bylayer" "")
  (ezo2)
 (princ))